<# 
.SYNOPSIS 
Delete Specified Item(s) From CCM Cache
.DESCRIPTION 
Uses ContentIDs to identify and purge content from the local ccm cache - Created by Gary Blok @gwblok
Partial Code borrowed from: https://gallery.technet.microsoft.com/scriptcenter/Deleting-the-SCCM-Cache-da03e4c7
Assist by Mark Godfrey @Geodesicz
.PARAMETER CachItemsToDelete
Comma separated values for the Content ID(s) of the cach item(s) to delete
.EXAMPLE 
.\Remove-CCMCacheContent.ps1 -CacheItemsToDelete "PS100123","20eb8ec8-0b7e-4831-a5ae-95680b11e6b5","PS111197"
.LINK
https://www.garytown.com
#> 

[CmdletBinding()]
Param(
    [Parameter(Mandatory=$true,Position=1,HelpMessage="ContentIDs")]
    [ValidateNotNullOrEmpty()]
    [String[]]$CacheItemsToDelete
)
#$CacheItemsToDelete = "PS100002","20eb8ec8-0b7e-4831-a5ae-95680b11e6b5","decbb5fe-1cbc-4984-bbf2-e76347150135"


#region: CMTraceLog Function formats logging in CMTrace style
        function CMTraceLog {
         [CmdletBinding()]
    Param (
		    [Parameter(Mandatory=$false)]
		    $Message,
 
		    [Parameter(Mandatory=$false)]
		    $ErrorMessage,
 
		    [Parameter(Mandatory=$false)]
		    $Component = "CacheCleanUp",
 
		    [Parameter(Mandatory=$false)]
		    [int]$Type,
		
		    [Parameter(Mandatory=$true)]
		    $LogFile
	    )
    <#
    Type: 1 = Normal, 2 = Warning (yellow), 3 = Error (red)
    #>
	    $Time = Get-Date -Format "HH:mm:ss.ffffff"
	    $Date = Get-Date -Format "MM-dd-yyyy"
 
	    if ($ErrorMessage -ne $null) {$Type = 3}
	    if ($Component -eq $null) {$Component = " "}
	    if ($Type -eq $null) {$Type = 1}
 
	    $LogMessage = "<![LOG[$Message $ErrorMessage" + "]LOG]!><time=`"$Time`" date=`"$Date`" component=`"$Component`" context=`"`" type=`"$Type`" thread=`"`" file=`"`">"
	    $LogMessage | Out-File -Append -Encoding UTF8 -FilePath $LogFile
    }

#Setup TS Environment
try
{
    $tsenv = New-Object -COMObject Microsoft.SMS.TSEnvironment
    $LogPath = $tsenv.Value('_SMSTSLogPath')
}
catch
{
	Write-Verbose "Not running in a task sequence."
    $LogPath = "C:\windows\ccm\logs"
}


$LogFile = "$LogPath\WaaS_PostUpgrade.log"
$ScriptName = $MyInvocation.MyCommand.Name

CMTraceLog -Message  "-----------------------------------------------" -Type 1 -LogFile $LogFile
CMTraceLog -Message  "Starting $ScriptName Script" -Type 1 -LogFile $LogFile
Write-Output "-----------------------------------------------"
Write-Output ""
# Connect to resource manager COM object    
$CMObject = New-Object -ComObject 'UIResource.UIResourceMgr' 
 
# Using GetCacheInfo method to return cache properties 
$CMCacheObjects = $CMObject.GetCacheInfo() 
 
# Delete Cache item 
$CMCacheObjects.GetCacheElements() | Where-Object {$_.ContentID -in $CacheItemsToDelete} | ForEach-Object { 
    $CMCacheObjects.DeleteCacheElement($_.CacheElementID)
    CMTraceLog -Message  "Deleted: Name: $($_.ContentID)  Version: $($_.ContentVersion)" -Type 1 -LogFile $LogFile
    Write-Output "Deleted: Name: $($_.ContentID)  Version: $($_.ContentVersion) From: $($_.Location)" -BackgroundColor 

}

Write-Output ""
Write-Output "-----------------------------------------------"
CMTraceLog -Message  "Finished $ScriptName Script" -Type 1 -LogFile $LogFile
CMTraceLog -Message  "-----------------------------------------------" -Type 1 -LogFile $LogFile